/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.network;

import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public abstract class BasePacketHandler {
    private int index = 0;

    protected static SimpleChannel createChannel(ResourceLocation name) {
        return NetworkRegistry.ChannelBuilder.named((ResourceLocation)name).clientAcceptedVersions(BasePacketHandler.getProtocolVersion()::equals).serverAcceptedVersions(BasePacketHandler.getProtocolVersion()::equals).networkProtocolVersion(BasePacketHandler::getProtocolVersion).simpleChannel();
    }

    private static String getProtocolVersion() {
        return "1";
    }

    public static String readString(FriendlyByteBuf buffer) {
        return buffer.m_130136_(Short.MAX_VALUE);
    }

    public static Player getPlayer(Supplier<NetworkEvent.Context> context) {
        return context.get().getSender();
    }

    protected abstract SimpleChannel getChannel();

    public abstract void initialize();

    protected <MSG> void registerClientToServer(Class<MSG> type, BiConsumer<MSG, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, MSG> decoder, BiConsumer<MSG, Supplier<NetworkEvent.Context>> consumer) {
        this.getChannel().registerMessage(this.index++, type, encoder, decoder, consumer, Optional.of(NetworkDirection.PLAY_TO_SERVER));
    }

    protected <MSG> void registerServerToClient(Class<MSG> type, BiConsumer<MSG, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, MSG> decoder, BiConsumer<MSG, Supplier<NetworkEvent.Context>> consumer) {
        this.getChannel().registerMessage(this.index++, type, encoder, decoder, consumer, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
    }

    public <MSG> void sendTo(MSG message, ServerPlayer player) {
        this.getChannel().sendTo(message, player.f_8906_.m_6198_(), NetworkDirection.PLAY_TO_CLIENT);
    }

    public <MSG> void sendToAll(MSG message) {
        this.getChannel().send(PacketDistributor.ALL.noArg(), message);
    }

    public <MSG> void sendToDimension(MSG message, ResourceKey<Level> dimension) {
        this.getChannel().send(PacketDistributor.DIMENSION.with(() -> dimension), message);
    }

    public <MSG> void sendToServer(MSG message) {
        this.getChannel().sendToServer(message);
    }

    public <MSG> void sendToAllTracking(MSG message, Entity entity) {
        this.getChannel().send(PacketDistributor.TRACKING_ENTITY.with(() -> entity), message);
    }

    public <MSG> void sendToAllTracking(MSG message, BlockEntity tile) {
        this.sendToAllTracking(message, tile.m_58904_(), tile.m_58899_());
    }

    public <MSG> void sendToAllTracking(MSG message, Level world, BlockPos pos) {
        if (world instanceof ServerLevel) {
            ((ServerLevel)world).m_7726_().f_8325_.m_183262_(new ChunkPos(pos), false).forEach(p -> this.sendTo(message, (ServerPlayer)p));
        } else {
            this.getChannel().send(PacketDistributor.TRACKING_CHUNK.with(() -> world.m_6325_(pos.m_123341_() >> 4, pos.m_123343_() >> 4)), message);
        }
    }
}

